/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.event;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jtbcore.event.EventMessage;
import jtbcore.event.MessageSubscriber;
import jtbcore.util.AppLogger;

public class MessageBus {
    protected static MessageBus instance = null;
    protected List<MessageSubscriber> subscribers;
    protected List<MessageSubscriber> todoUnsub = new ArrayList<MessageSubscriber>();

    public MessageBus() {
        this.subscribers = new LinkedList<MessageSubscriber>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(MessageSubscriber sub) {
        List<MessageSubscriber> list = this.subscribers;
        synchronized (list) {
            if (this.subscribers.contains(sub)) {
                AppLogger.error("Error: already object subscribed");
                return;
            }
            this.subscribers.add(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(MessageSubscriber sub) {
        List<MessageSubscriber> list = this.subscribers;
        synchronized (list) {
            this.todoUnsub.add(sub);
        }
    }

    public void sendMessage(String msg) {
        EventMessage m = new EventMessage(msg);
        this.sendMessage(m);
    }

    public void sendMessage(String msg, Object value) {
        EventMessage m = new EventMessage(msg);
        m.setProp("value", value);
        this.sendMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(EventMessage m) {
        List<MessageSubscriber> list = this.subscribers;
        synchronized (list) {
            if (this.todoUnsub.size() > 0) {
                this.subscribers.removeAll(this.todoUnsub);
                this.todoUnsub.clear();
            }
            for (MessageSubscriber s : this.subscribers) {
                s.message(m);
            }
        }
    }

    public static synchronized MessageBus getInstance() {
        if (instance == null) {
            instance = new MessageBus();
        }
        return instance;
    }
}

